<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */
 
  /*===================================================
    ShowFormSendMail()
  ===================================================*/

  function ShowFormSendMail() {

    // vars global configuration
    global $dbConn, $theme_path;

    // vars url & form
    global $u, $lid, $revid, $to;

    // vars messages
    global $msg;

    // vars template
    global $error_msg, $email, $name, $body, $subject;

    if ($u) {
      $to = $u;
    }
    elseif ($lid) {
      $to = $dbConn->Lookup('contact_name', 'idx_link', "link_id = '$lid'");
    }
    elseif ($revid) {
      $to = $dbConn->Lookup('username', 'idx_review', "review_id = '$revid'");
      if (!$to) {
        $to = $dbConn->Lookup('name', 'idx_review', "review_id = '$revid'");
      }
    }

    $name    = stripslashes($name);
    $subject = stripslashes($subject);
    $body    = stripslashes($body);

    DisplayTemplate($theme_path . "sendmail_form.html", "\$error_msg,\$email,\$name,\$to,\$u,\$lid,\$revid,\$body,\$subject");
  }


  /*===================================================
    ProcessFormSendMail()
  ===================================================*/
  
  function ProcessFormSendMail() {

    // vars global configuration
    global $dbConn, $theme_path;

    // vars url & form
    global $error_msg, $email, $name, $u, $lid, $revid, $to, $body, $subject;

    // vars messages
    global $msg;

    // vars template
    global $error_msg;

    // verify input

    $name    = stripslashes($name);
    $subject = stripslashes($subject);
    $body    = stripslashes($body);

    if (empty($email))
      $error_msg = $msg["10282"];
    elseif (!IsEmailAddress($email))
      $error_msg = $msg["10283"];

    if (empty($error_msg)) {
      if ($u) {
        $users_obj             = new clsUsers;
        $users_obj->table_name = "idx_users";
        $email_to              = $users_obj->GetEmailAddress($u);
      }
      elseif ($lid) {
        $email_to = $dbConn->Lookup('email', 'idx_link', "link_id = '$lid'");
      }
      elseif ($revid) {
        $email_to = $dbConn->Lookup('email', 'idx_review', "review_id = '$revid'");
        if (!$email_to) {
          $to = $dbConn->Lookup('username', 'idx_review', "review_id = '$revid'");
          $users_obj             = new clsUsers;
          $users_obj->table_name = "idx_users";
          $email_to              = $users_obj->GetEmailAddress($to);
        }
      }
      
      $email_from = $email;
      $from       = $name . "<$email_from>";
      @mail($email_to, $subject, $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");

      DisplayTemplate($theme_path . "sendmail_ok.html", "\$to,\$u");
    }
    else {
      ShowFormSendMail();
    }
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  RunPreFilter(__FILE__);

  if (empty($pflag)) {
    ShowFormSendMail();
  }
  elseif ($pflag == 'send') {
    ProcessFormSendMail();
  }

  RunPostFilter(__FILE__);

?>